<?php
/*
Plugin Name: xF-Wordpress Bridge
Description: Integrates the xenForo platform with Wordpress.
Version: 1.2
Author: Faeron and Ocean
*/

/**
 * global option
*/
define('XEN_INTEGRATION_KEY','xenForo_integrationID');
$xenPath = get_option('xen_path');
$domain = get_option('xen_domain');
if ( !function_exists('get_userdatabylogin') ) :
/**
 * Retrieve user info by login name.
 *
 * @since 0.71
 * @deprecated 3.3.0
 * @deprecated Use get_user_by('login')
 *
 * @param string $user_login User's username
 * @return bool|object False on failure, User DB row object
 */
function get_userdatabylogin($user_login) {
	_deprecated_function( __FUNCTION__, '3.3', "get_user_by('login')" );
	return get_user_by('login', $user_login);
}
endif;
if ( !function_exists('get_user_by') ) :
/**
 * Retrieve user info by a given field
 *
 * @since 2.8.0
 *
 * @param string $field The field to retrieve the user with. id | slug | email | login
 * @param int|string $value A value for $field. A user ID, slug, email address, or login name.
 * @return bool|object False on failure, WP_User object on success
 */
function get_user_by( $field, $value ) {
	$userdata = WP_User::get_data_by( $field, $value );

	if ( !$userdata )
		return false;

	$user = new WP_User;
	$user->init( $userdata );

	return $user;
}
endif;
if (!empty($xenPath) && is_dir($xenPath)) {
	$xenFullPaths = array(
		realpath(ABSPATH . '/' . $xenPath), 
		realpath($xenPath), 
	);
	foreach ($xenFullPaths as $xenFullPath) {
		if (is_dir($xenFullPath)) {
			define('XENFORO_PATH',$xenFullPath);
			break; 
		}
	}
    
//    var_dump(XENFORO_PATH);exit;
//    require(XENFORO_PATH . '/library/XenForo/Autoloader.php');
//    XenForo_Autoloader::getInstance()->setupAutoloader(XENFORO_PATH . '/library');
//    XenForo_Application::initialize(XENFORO_PATH . '/library', XENFORO_PATH);
//    $startTime = microtime(true);
//    XenForo_Application::set('page_start_time', $startTime);
////    XenForo_Application::disablePhpErrorHandler();
//    error_reporting( E_ALL ^ E_NOTICE ^ E_USER_NOTICE );
	if (defined('XENFORO_PATH') && is_dir(XENFORO_PATH)) {
		 if(!class_exists("XenForo_Autoloader")) {
//            require_once(XENFORO_PATH . '/library/XenForo/Autoloader.php');
//            XenForo_Autoloader::getInstance()->setupAutoloader(XENFORO_PATH . '/library');
//            XenForo_Application::initialize(XENFORO_PATH . '/library', XENFORO_PATH);
        }
		if (strpos($_SERVER['REQUEST_URI'],'wp-login.php') !== false) {
			if (!empty($_REQUEST['action'])) {
				switch ($_REQUEST['action']) {
					case 'lostpassword': $xen = Xen::create()->redirect('lost-password');
					case 'register': $xen = Xen::create()->redirect('register');
				}
			} else if (empty($_GET)) {
				$xen = Xen::create()->redirect('login');
			} else {
				$location = site_url('');
				header("Location: $location");
				exit;
			}
		} elseif(preg_match('/^\/author\/(.*)$/',$_SERVER['REQUEST_URI'],$matches)) {
            //author

            $user = get_userdatabylogin(trim($matches[1],'/'));
            $xen_id= get_user_meta($user->ID,XEN_INTEGRATION_KEY);#var_dump($xen_id);exit;
            if ($xen_id) {
                $location = $domain.'/members/'.$xen_id[0];
                header("Location: $location");
                exit;
            }
        }
	}
}
add_action('admin_menu', 'xen_admin_menu');
function xen_admin_menu() {
	add_options_page('Xen Conf','Xen','manage_options','xen_conf','xen_admin_page');
}


/**
 * xen init
 */

add_action('admin_init', 'xen_admin_init'); 
    
function xen_admin_init() {
	register_setting('xen-settings-group', 'xen_path');
	register_setting('xen-settings-group', 'xen_domain');
    register_setting('xen-settings-group', 'xen_roles_map');
	if (class_exists('Xen')) {
		if (defined('IS_PROFILE_PAGE')) {
			Xen::create()->redirect('account');
		}
		if (isset($GLOBALS['parent_file']) AND $GLOBALS['parent_file'] == 'users.php') {
			wp_safe_redirect(Xen::create()->options['boardUrl'] . '/admin.php?users/');
		}
	}
}
function xen_admin_page_roles($fieldname,$selected = null) {
	static $names = null;
//    var_dump($names);exit;
	if (empty($names)) {
		global $wp_roles;
		if (!isset($wp_roles)) {
			require_once( ABSPATH . WPINC . '/capabilities.php');
			$wp_roles = new WP_Roles();
		}
		$names = $wp_roles->get_names();
//        print_r($names);exit;
    }
    ?>
<select name="<?php echo $fieldname; ?>">
	<option value=""><?php echo __('Default'); ?></option>
<?php foreach ($names as $varname => $displayname): ?>
	<option value="<?php echo $varname; ?>"<?php if ($varname == $selected): ?> selected="selected"<?php endif; ?>><?php echo $displayname; ?></option>
<?php endforeach; ?>
</select>
<?php
}

/**
 * page manage
 */
function xen_admin_page() {
	if (!current_user_can('manage_options'))  {
		wp_die(__('No permission!') );
	}
    if (class_exists('Xen') && defined('XENFORO_PATH')) {
		$xen = Xen::create();
		$usergroups = $xen->getUsergroups();
		$roles_map =& $xen->options['roles_map'];
//		$proxyBase = $xen->getProxyBase();
	} else {
		$usergroups = array();
		$roles_map = array();
//		$proxyBase = false;
	}
//    print_r($roles_map);print_r($usergroups);
    
?>
<div class="wrap">

<div style="width: 700px;">
<center><h2>xF-Wordpress Bridge Settings</h2></center>
<form method="post" action="options.php">
	<table class="form-table">
		<?php settings_fields('xen-settings-group'); ?>
        <tr value="top">
        <h3> General Setting </h3>
        </tr>
		<th scope="row" nowrap="nowrap">Location of your xF installation</th>
		<td>
			<div>
				<input type="text" name="xen_path" value="<?php echo get_option('xen_path'); ?>" class="regular-text"/>
			</div>
			<div>Please provide the absolute path of your xenForo Installation. (No Trailing Slash)
            <br /> 
            For Example: /home/username/public_html/community</div>
		</td>
		</tr>
        <tr valign="top">
            <th scope="row" nowrap="nowrap">xenForo Domain</th>
            <td>
                <div>
                <input type="text" name="xen_domain" value="<?php echo get_option('xen_domain');?>" class="regular-text"/>
                <?php if(!filter_var(get_option('xen_domain'),FILTER_VALIDATE_URL)) {?><span class="error-message">Invalid domain</span><?php }?>
                </div>
                <div>For Example: http://www.yoursite.com/community (No Trailing Slash)</div>
            </td>
        
        </tr>
        
        <tr value="top">
        <h3> Usergroup Mapping </h3>
        </tr>
        
        <?php foreach ($usergroups as $usergroup): ?>
		<tr valign="top">
		<th scope="row" nowrap="nowrap"><?php echo __('Role for') . ' ' . $usergroup->title . ' (#' . $usergroup->user_group_id . ')'; ?></th>
		<td><?php xen_admin_page_roles('xen_roles_map[' . $usergroup->user_group_id . ']', @$roles_map["{$usergroup->user_group_id}"]); ?></td>
        </tr>
		<?php endforeach; ?>
	</table>
	
	<p class="submit">
	<input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
	</p>
</form>
</div>
</div>
<?php
}


/**
 * login options
 */

if (!function_exists('wp304_validate_auth_cookie') ) {
    function wp304_validate_auth_cookie($cookie = '', $scheme = '') {
		if ( ! $cookie_elements = wp_parse_auth_cookie($cookie, $scheme) ) {
			do_action('auth_cookie_malformed', $cookie, $scheme);
			return false;
		}

		extract($cookie_elements, EXTR_OVERWRITE);

		$expired = $expiration;

		// Allow a grace period for POST and AJAX requests
		if ( defined('DOING_AJAX') || 'POST' == $_SERVER['REQUEST_METHOD'] )
			$expired += 3600;

		// Quick check to see if an honest cookie has expired
		if ( $expired < time() ) {
			do_action('auth_cookie_expired', $cookie_elements);
			return false;
		}

		$user = get_user_by('login',$username);
		if ( ! $user ) {
			do_action('auth_cookie_bad_username', $cookie_elements);
			return false;
		}

		$pass_frag = substr($user->user_pass, 8, 4);

		$key = wp_hash($username . $pass_frag . '|' . $expiration, $scheme);
		$hash = hash_hmac('md5', $username . '|' . $expiration, $key);

		if ( $hmac != $hash ) {
			do_action('auth_cookie_bad_hash', $cookie_elements);
			return false;
		}

		if ( $expiration < time() ) // AJAX/POST grace period set above
			$GLOBALS['login_grace_period'] = 1;

		do_action('auth_cookie_valid', $cookie_elements, $user);

		return $user->ID;
	}
}


//var_dump(function_exists('wp_validate_auth_cookie'));exit;
if (!function_exists('wp_validate_auth_cookie')) {
    
	function wp_validate_auth_cookie($cookie = '', $scheme = '') {
//        print_R(debug_backtrace());exit;
		$wp_userid = wp304_validate_auth_cookie($cookie, $scheme);#var_dump($wp_userid);exit;
		if (empty($wp_userid)) $wp_userid = Xen::create()->validate_auth_cookie(); 
//        if($wp_userid) wp_set_auth_cookie($wp_userid,true);
		return $wp_userid;
	}
} else {
    $wp_userid = wp304_validate_auth_cookie($cookie, $scheme);
    if (empty($wp_userid)) $wp_userid = Xen::create()->validate_auth_cookie(); 
    if($wp_userid) wp_set_auth_cookie($wp_userid,true);
}

if (!function_exists('wp_set_auth_cookie')) {
	function wp_set_auth_cookie($user_id, $remember = false, $secure = '') {
		if ( $remember ) {
		$expiration = $expire = time() + apply_filters('auth_cookie_expiration', 1209600, $user_id, $remember);
	} else {
		$expiration = time() + apply_filters('auth_cookie_expiration', 172800, $user_id, $remember);
		$expire = 0;
	}

	if ( '' === $secure )
		$secure = is_ssl();

	$secure = apply_filters('secure_auth_cookie', $secure, $user_id);
	$secure_logged_in_cookie = apply_filters('secure_logged_in_cookie', false, $user_id, $secure);

	if ( $secure ) {
		$auth_cookie_name = SECURE_AUTH_COOKIE;
		$scheme = 'secure_auth';
	} else {
		$auth_cookie_name = AUTH_COOKIE;
		$scheme = 'auth';
	}

	$auth_cookie = wp_generate_auth_cookie($user_id, $expiration, $scheme);
	$logged_in_cookie = wp_generate_auth_cookie($user_id, $expiration, 'logged_in');

	do_action('set_auth_cookie', $auth_cookie, $expire, $expiration, $user_id, $scheme);
	do_action('set_logged_in_cookie', $logged_in_cookie, $expire, $expiration, $user_id, 'logged_in');

	setcookie($auth_cookie_name, $auth_cookie, $expire, PLUGINS_COOKIE_PATH, COOKIE_DOMAIN, $secure, true);
	setcookie($auth_cookie_name, $auth_cookie, $expire, ADMIN_COOKIE_PATH, COOKIE_DOMAIN, $secure, true);
	setcookie(LOGGED_IN_COOKIE, $logged_in_cookie, $expire, COOKIEPATH, COOKIE_DOMAIN, $secure_logged_in_cookie, true);
	if ( COOKIEPATH != SITECOOKIEPATH )
		setcookie(LOGGED_IN_COOKIE, $logged_in_cookie, $expire, SITECOOKIEPATH, COOKIE_DOMAIN, $secure_logged_in_cookie, true);
	}
}

function get_user_by_meta_data( $meta_key, $meta_value ) {
    // Query for users based on the meta data
    $user_query = new WP_User_Query(
     array(
      'meta_key'   => $meta_key,
      'meta_value' => $meta_value
     )
    );

    // Get the results from the query, returning the first user
    $users = $user_query->get_results();

    return $users[0];
} 

function xen_logout() {
	Xen::create()->logout();
}
add_action('wp_logout', 'xen_logout');

/**
 * avatar sync
 */
function function_dump($funcname) {
    try {

        if(is_array($funcname)) {
            $func = new ReflectionMethod($funcname[0], $funcname[1]);
            $funcname = $funcname[1];
        } else {
            $func = new ReflectionFunction($funcname);
        }
        
    } catch (ReflectionException $e) {
        echo $e->getMessage();
        return;
    }

    $start = $func->getStartLine() - 1;

    $end =  $func->getEndLine() - 1;

    $filename = $func->getFileName();

    echo "function $funcname defined by $filename($start - $end)\n";
}
#var_dump(function_exists( 'get_avatar' ));print_R(debug_backtrace());
#function_dump('get_avatar');exit;
if (defined('XENFORO_PATH') && is_dir(realpath(XENFORO_PATH))) :
if (!function_exists( 'get_avatar' )  ) {
function get_avatar($id_or_email, $size = '96', $default = '', $alt = false) {
	if ( ! get_option('show_avatars') )
		return false;

	if ( false === $alt)
		$safe_alt = '';
	else
		$safe_alt = esc_attr( $alt );

	if ( !is_numeric($size) )
		$size = '96';

    $email = '';
	if ( is_numeric($id_or_email) ) {
		$id = (int) $id_or_email;
		$user = get_userdata($id);
		if ( $user )
			$email = $user->user_email;
	} elseif ( is_object($id_or_email) ) {
		// No avatar for pingbacks or trackbacks
		$allowed_comment_types = apply_filters( 'get_avatar_comment_types', array( 'comment' ) );
		if ( ! empty( $id_or_email->comment_type ) && ! in_array( $id_or_email->comment_type, (array) $allowed_comment_types ) )
			return false;

		if ( !empty($id_or_email->user_id) ) {
			$id = (int) $id_or_email->user_id;
			$user = get_userdata($id);
			if ( $user)
				$email = $user->user_email;
		} elseif ( !empty($id_or_email->comment_author_email) ) {
			$email = $id_or_email->comment_author_email;
		}
	} else {
		$email = $id_or_email;
	}
    $xen_user = Xen::create()->getUserByEmail($email);
    if(!class_exists("XenForo_Autoloader")) {
        require_once(XENFORO_PATH . '/library/XenForo/Autoloader.php');
        XenForo_Autoloader::getInstance()->setupAutoloader(XENFORO_PATH . '/library');
//        XenForo_Application::initialize(XENFORO_PATH . '/library', XENFORO_PATH);
    }
    $xen_domain = get_option('xen_domain');
    $out = XenForo_Template_Helper_Core::helperAvatarUrl((array)$xen_user, 'm', false);
    $out = $xen_domain.'/'.$out;
	$avatar = "<img alt='{$safe_alt}' src='{$out}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}' />";
//var_dump($avatar);exit;
	return apply_filters('get_avatar', $avatar, $id_or_email, $size, $default, $alt);
}
} 
endif;

/**
 * core class
 */
class Xen {
	function __construct() {
		$this->DIR = realpath(XENFORO_PATH);
		if (is_dir($this->DIR)) {
			$this->DIR .= '/';
		} else {
			trigger_error('Unable to communicate with Xen system', E_ERROR);
		}
		
		$this->load_config();
		
		$this->COOKIE_PREFIX = $this->config['cookie']['prefix'];
		
		$this->prepare_db();
		$this->load_options();
		
		$this->userinfo = null;
		$this->strikes = 0;
	}
	
	function load_config() {
		// default config from XenForo_Application
		// remove parts out of interest
		$config = array(
			'db' => array(
				'adapter' => 'mysqli',
				'host' => 'localhost',
				'port' => '3306',
				'username' => '',
				'password' => '',
				'dbname' => ''
			),
//			'globalSalt' => get_option('xen_globalSalt'),
			'cookie' => array(
				'prefix' => 'xen_',
				'path' => '/',
				'domain' => ''
			),
			'internalDataPath' => 'internal_data',
			'session' => array( // this one is from XenForo_Session
				'ipCidrMatch' => 24,
			),
		);
		require($this->DIR . 'library/config.php'); 
        $config['cookie'] =array(
				'prefix' => 'xf_',
				'path' => '/',
				'domain' => ''
			);
		$this->config = $config;		
		$required = array('db','cookie');
		foreach ($required as $key) {
			if (empty($this->config[$key])) {
				echo "XenForo configuration missing: $key. Auto disabled the bridge, please re-configure...";
				update_option('xen_path', '');
				exit;
			}
		}
	}
	
	function prepare_db() {
		//keep an instance of Wordpress's db
		$this->wpdb =& $GLOBALS['wpdb'];
		
		//setup XenForo's db
		$db_host = $this->config['db']['host'];
		$db_user = $this->config['db']['username'];
		$db_password = $this->config['db']['password'];
		$db_name = $this->config['db']['dbname'];
		if ($db_user == DB_USER AND $db_password == DB_PASSWORD AND $db_name == DB_NAME AND $db_host == DB_HOST) {
//            var_dump($this->xendb);exit;
			//wow, same database for Wordpress and XenForo, use the existing wpdb object
			$this->xendb =& $GLOBALS['wpdb'];
		} else {
			//create a new connection
//             var_dump($this->xendb);exit;
//            print_r($this->config);exit;
			$this->xendb = new wpdb($db_user, $db_password, $db_name, $db_host);
//             var_dump($this->xendb);exit;
		}
	}
	
	function load_options() {
		$this->options = array();
		
		$roles_map = get_option('xen_roles_map');
		if (empty($roles_map)) {
			//it appears like the plugin has just been installed
			//we will automatically map the Administrative usergroup (#3) with administrator user role
			$roles_map = array(
				'3' => 'administrator',
			);
			add_option('xenforo_roles_map', $roles_map, '', 'yes'); //we want this auto loaded, improve performance
		}
		$this->options['roles_map'] = $roles_map;

		// $xenOptions = get_option('xen_options');
		$xenOptions = array();
		$xenOptions_required = array(
			'boardTitle',
			'boardUrl',
			'useFriendlyUrls',
			/* ours */
			'bdwpp_routing_mode',
			'bdwpp_route_prefix',
			'bdwpp_wp_path',
		);
		if (class_exists('XenForo_Application')) {
			// we are inside XenForo, feeling so great!
			$xenOptionsRaw = XenForo_Application::get('options');
			foreach ($xenOptions_required as $xenOptionId) {
				$xenOptions[$xenOptionId] = $xenOptionsRaw->$xenOptionId;
			}
		} else {
			if ($xenOptions === false OR count($xenOptions) != count($xenOptions_required)) {
				$xenOptions_raw = $this->xendb->get_results("
					SELECT option_id, option_value
					FROM `xf_option`
					WHERE option_id IN ('" . implode("','", $xenOptions_required) . "')
				");
				$xenOptions = array();
				foreach ($xenOptions_raw as $xenOption) {
					$xenOptions[$xenOption->option_id] = $xenOption->option_value;
				}
				// add_option('xenforo_options', $xenOptions, '', 'yes');
			}
		}
		$this->options = array_merge($this->options, $xenOptions);
//        print_r($this->options);
	}
	
	static function create() {
		static $instance;
		
		if (empty($instance)) $instance = new Xen();
		
		return $instance;
	}
	
	//main function
	function validate_auth_cookie() {
		$sessionId = @$_COOKIE[$this->COOKIE_PREFIX . 'session'];
		$usercookie = @$_COOKIE[$this->COOKIE_PREFIX . 'user'];
		$gotsession = false;
		$session = null;
		$userinfo = null;
		if (class_exists('XenForo_Visitor')) {
			$visitor =& XenForo_Visitor::getInstance();
			if ($visitor->get('user_id') > 0) {
				$array = $visitor->toArray();
				$userinfo = new StdClass();
				foreach ($array as $akey => $avalue) {
					$userinfo->$akey = $avalue;
				}
			}
		} else {
			if ($sessionId) {
				$session = $this->xendb->get_row("
					SELECT *
					FROM `xf_session`
					WHERE session_id = '" . $this->xendb->_real_escape($sessionId) /* we don't want to be hacked */ . "'
						AND expiry_date > " . time() . "
				");
				if (!empty($session)) {
					$session->session_data = unserialize($session->session_data);
					$ipAddress = $this->getIpAddressHash();
					if (empty($ipAddress) OR empty($this->config['session']['ipCidrMatch']) OR $this->config['session']['ipCidrMatch'] < 0) {
						// let it through
					} else {
						// check the IP address
						// code copied from XenForo_Session
						$shiftAmount = 32 - min($this->config['session']['ipCidrMatch'], 32);
						$ipMatched = (($session->session_data['ip'] >> $shiftAmount) === ($ipAddress >> $shiftAmount));
						if (!$ipMatched) {
							$session = false;
						}
					}
					
				}
				if (!empty($session)) {
					$gotsession = true;
					// found a session - get the userinfo
					if (!empty($session->session_data['user_id'])) {
						$userinfo = $this->setupUser($session->session_data['user_id']);
					}
				}
			}
			
			if ($gotsession == false OR empty($userinfo) AND $usercookie) {
				// try to login using cookie
				// code copied from XenForo_Model_User
				$parts = explode(',', $usercookie);
				if (count($parts) >= 2) {
					$userId = intval($parts[0]);
					$rememberKey = $parts[1];
					if (!empty($userId) AND !empty($rememberKey)) {
						$authRecord = $this->getAuthRecord($userId);
						if (empty($authRecord)) {
							// *sigh*
						} else if ($rememberKey == $this->hashRememberKey($authRecord->remember_key)) {
							// wow!
							$userinfo = $this->setupUser($userId);
							$this->setCookie('user',$usercookie,time() + 7*86400); // simply extend the current cookie value
						}
					}
				}
			}
		}
		
		if (!empty($userinfo)) {
			$wp_userinfo = $this->createUser($userinfo);
			$wp_userid = $wp_userinfo->ID;
		}
		
		if (!empty($wp_userid)) {
			$this->userinfo =& $userinfo; //store our XenForo's userinfo
			$this->session =& $session;
			return $wp_userid;
		} else {
			return 0;
		}
	}
	
	function logout() {
		$nonce = $_REQUEST['_wpnonce'];
		if (!wp_verify_nonce($nonce, 'log-out')) die('Security check'); // the action 'log-out' is used by WP
		
		if (!empty($this->userinfo) AND $this->userinfo->is_admin) {
			// remove admin session if any
			$adminSessionId = @$_COOKIE[$this->COOKIE_PREFIX . 'admin_session'];
			$adminSession = $this->xendb->query("
				DELETE
				FROM `xf_session_admin`
				WHERE session_id = '" . $this->xendb->_real_escape($adminSessionId) . "'
			");
		}

		// clear all cookies beginning with COOKIE_PREFIX
		// code copied from vBulletin
		$prefix_length = strlen($this->COOKIE_PREFIX);
		$cookie_vars = array();
		foreach ($_COOKIE AS $key => $val) {
			$index = strpos($key, $this->COOKIE_PREFIX);
			if ($index == 0 AND $index !== false) {
				$key = substr($key, $prefix_length);
				if (trim($key) == '') {
					continue;
				}
				$cookie_vars[$key] = '';
			}
		}
		foreach ($cookie_vars as $key => $value) {
			$this->setCookie($key,false);
		}

		if (!empty($this->session)) {
			$this->xendb->query("
				DELETE
				FROM `xf_session`
				WHERE session_id = '" . $this->session->session_id . "'
			");
		}
		
		
	}
	
	function setupUser($user_id) {
		$user_id = intval($user_id);
		return $this->xendb->get_row("
			SELECT *
			FROM `xf_user`
			WHERE user_id = $user_id
		");
	}
    
    function getUserByEmail($email) {
        return $this->xendb->get_row("
            SELECT * FROM `xf_user`
            WHERE email = '{$email}'");
    }
	
	function getUsergroups() {
		return $this->xendb->get_results("
			SELECT *
			FROM `xf_user_group`
		");
	}
	
	function getForums() {
		return $this->xendb->get_results("
			SELECT *
			FROM `xf_node`
			WHERE node_type_id = 'Forum'
		");
	}
    
	//create Wordpress user record if needed
	function createUser($userinfo) {
		require_once(ABSPATH . WPINC . '/registration.php');
        
//		$wp_userinfo = get_userdatabylogin($userinfo->username);

        $wp_userinfo = get_user_by_meta_data(XEN_INTEGRATION_KEY,$userinfo->user_id);
        if (empty($wp_userinfo)) {
            $wp_userinfo = get_user_by('email', $userinfo->email);
        }
        if (empty($wp_userinfo)){
            $wp_userinfo = get_userdatabylogin($userinfo->username);
        }

		$correct_role = $this->findSuitableRole($userinfo);

		if (empty($wp_userinfo->ID)) {
			// use a semi-random password for the generated user...
//            $authenticate = $this->getAuthRecord($userinfo->user_id);
//            $auth = XenForo_Authentication_Abstract::create($authenticate['scheme_class']);
//            if (!$auth)
//            {
//                return false;
//            }
//
//            $auth->setData($authenticate['data']);
//            return $auth;
			$wp_userid = wp_create_user($userinfo->username, $userinfo->email, $userinfo->email);
			if ($wp_userid instanceof WP_Error) {
				// the only error can happen is existed email...
				// create a new user with fake address now, LOL
				$wp_userid = wp_create_user($userinfo->username, $userinfo->email, md5($userinfo->username) . '@faked-email-address.com');
			}
            
//			$wp_userinfo = get_userdatabylogin($userinfo->username);
            $wp_userinfo = get_user_by('id',$wp_userid);
            add_user_meta($wp_userid,XEN_INTEGRATION_KEY,$userinfo->user_id,true);
		} 
//        var_dump(!get_user_meta($wp_userinfo->ID,XEN_INTEGRATION_KEY));
        $exists = get_user_meta($wp_userinfo->ID,XEN_INTEGRATION_KEY);
//        $exists = get_user_meta(88,XEN_INTEGRATION_KEY);var_dump($exists);exit;
        if (empty($exists)) {
           add_user_meta($wp_userinfo->ID,XEN_INTEGRATION_KEY,$userinfo->user_id,true);
        }
//        $xen_info = get_user_by('ID',get_user_meta($wp_userinfo->ID,XEN_INTEGRATION_KEY));
        if ($wp_userinfo->user_login != $userinfo->username || $wp_userinfo->user_email != $userinfo->email) {
//            $update = array(
//                'ID'=>$wp_userinfo->ID,
//                'user_login'=>$userinfo->username,
//                'user_email'=>$userinfo->email
//            );
            global $wpdb;
            $wpdb->update($wpdb->users, array('user_login' => $userinfo->username,'user_email'=>$userinfo->email,'user_nicename'=>$userinfo->username,'display_name'=>$userinfo->username), array('ID' => $wp_userinfo->ID));
//            wp_cache_delete($userinfo->email, 'useremail');
        }
       
		
		if (!empty($wp_userinfo)) {
			//validate user's role
			if (!empty($correct_role)) {
				$cap = @$wp_userinfo->{$this->wpdb->prefix . 'capabilities'};
				if (empty($cap)) {
					// hmm, MU?
					$cap = @$wp_userinfo->wp_capabilities;
				}
				if (is_array($cap)) {
					if (!isset($cap[$correct_role]) OR empty($cap[$correct_role])) {
						$user = new WP_User($wp_userinfo->ID);					
						$user->set_role($correct_role);
					}
				}
			}
		}
		
		return $wp_userinfo;
	}
	
	//find a role for a user
	function findSuitableRole($userinfo) {
		global $wp_roles;
		if (!isset($wp_roles)) $wp_roles = new WP_Roles();
		$varnames = array_keys($wp_roles->get_names());
		$userGroupIds = array($userinfo->user_group_id);
		$secondary_group_ids = explode(',',$userinfo->secondary_group_ids);
		if (!empty($secondary_group_ids)) {
			foreach ($secondary_group_ids as $id) {
				if (!empty($id)) $userGroupIds[] = $id;
			}
		}
		
		foreach ($varnames as $varname) {
			foreach ($this->options['roles_map'] as $id => $role) {
				if (!empty($role) AND $role == $varname AND in_array($id,$userGroupIds)) return $role;
			}
		}
		return null;
	}
	
	function getIpAddressHash() {
		$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false);
		if (is_string($ipAddress) && strpos($ipAddress, '.')) {
			$ipAddress = ip2long($ipAddress); // LOL, thanks XF. I haven't known this function yet
		} else {
			$ipAddress = false;
		}
		return $ipAddress;
	}
	
	function getAuthRecord($userId) {
		$userId = intval($userId);
		return $this->xendb->get_row("
			SELECT *
			FROM `xf_user_authenticate`
			WHERE user_id = $userId
		");
	}
	
	function hashRememberKey($rememberKey) {
		return sha1($this->config['globalSalt'] . $rememberKey);
	}
	
	function setCookie($name,$value,$exp = 0,$httpOnly = false,$secure = null) {
		$path = $this->config['cookie']['path'];
		$domain = $this->config['cookie']['domain'];
		if ($value === false) {
			$exp = time() - 86400*365;
		}
		$name = $this->config['cookie']['prefix'] . $name;
		
		return setcookie($name, $value, $exp, $path, $domain, $secure, $httpOnly);
	}
	
	function redirect($target) {
		header("Location: " . $this->buildPublicLink($target));
		exit;
	}
	
	function buildPublicLink($target, array $data = array()) {
		if (class_exists('XenForo_Link')) {
//            var_dump(XenForo_Link::buildPublicLink('full:' . $target, $data));exit;
			return XenForo_Link::buildPublicLink('full:' . $target, $data);
		}
		$parts = explode('/', $target);
		$target = $parts[0];
		$subtarget = count($parts) > 1?$parts[1]:'';
		
		switch ($target) {
			case 'threads':
				$path = 'threads/' . $data['thread_id'] . ($subtarget?('/' . $subtarget):'');
				break;
			default:
				$path = $target . ($subtarget?('/' . $subtarget):'');
		}
		
		if ($path == 'index') {
			$link = $this->options['boardUrl'] . '/';
		} elseif ($this->options['useFriendlyUrls']) {
			$link = $this->options['boardUrl'] . "/$path/";
		} else {
			$link = $this->options['boardUrl'] . "/index.php?$path/";
		}
		
		return $link;
	}
	
	function getUserInfo($key = false) {
		if (!empty($this->userinfo)) {
			if ($key !== false) {
				return $this->userinfo->$key;
			} else {
				return (array) ($this->userinfo);
			}
		} else {
			return array(
				'user_id' => 0,
				'username' => 'Guest',
				'gender' => '',
			);
		}
	}
	
	function getUserId() {
		if (!empty($this->userinfo)) {
			return $this->userinfo->user_id;
		} else {
			return 0;
		}
	}
	
	
}